/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.shapes;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import dev.gigaherz.jsonthings.things.shapes.IShapeProvider;
import dev.gigaherz.jsonthings.util.CodecExtras;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CombinedShape
implements IShapeProvider {
    public static final BiMap<String, BooleanOp> BOOLEAN_OPERATORS = ImmutableBiMap.builder().put((Object)"false", (Object)BooleanOp.f_82681_).put((Object)"not_or", (Object)BooleanOp.f_82682_).put((Object)"only_second", (Object)BooleanOp.f_82683_).put((Object)"not_first", (Object)BooleanOp.f_82684_).put((Object)"only_first", (Object)BooleanOp.f_82685_).put((Object)"not_second", (Object)BooleanOp.f_82686_).put((Object)"not_same", (Object)BooleanOp.f_82687_).put((Object)"not_and", (Object)BooleanOp.f_82688_).put((Object)"and", (Object)BooleanOp.f_82689_).put((Object)"same", (Object)BooleanOp.f_82690_).put((Object)"second", (Object)BooleanOp.f_82691_).put((Object)"causes", (Object)BooleanOp.f_82692_).put((Object)"first", (Object)BooleanOp.f_82693_).put((Object)"caused_by", (Object)BooleanOp.f_82694_).put((Object)"or", (Object)BooleanOp.f_82695_).put((Object)"true", (Object)BooleanOp.f_82696_).build();
    public static final Codec<BooleanOp> BOOLEAN_OP_CODEC = CodecExtras.mappingCodec(Codec.STRING, arg_0 -> BOOLEAN_OPERATORS.get(arg_0), arg_0 -> BOOLEAN_OPERATORS.inverse().get(arg_0));
    public static final Codec<CombinedShape> LIST_CODEC = CodecExtras.lazy(DynamicShape::shapeCodec).listOf().flatComapMap(list -> new CombinedShape(BooleanOp.f_82695_, (Collection<IShapeProvider>)list), shape -> shape.operator == BooleanOp.f_82695_ ? DataResult.success(shape.boxes) : DataResult.error(() -> "Cannot use CombinedShape.LIST_CODEC to encode a CombinedShape whose boolean function is not OR"));
    public static final Codec<CombinedShape> OBJECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BOOLEAN_OP_CODEC.fieldOf("op").forGetter(shape -> shape.operator), (App)CodecExtras.lazy(DynamicShape::shapeCodec).listOf().fieldOf("shapes").forGetter(shape -> shape.boxes)).apply((Applicative)instance, CombinedShape::new));
    public static final Codec<CombinedShape> CODEC = CodecExtras.makeChoiceCodec(LIST_CODEC, OBJECT_CODEC);
    public final BooleanOp operator;
    public final List<IShapeProvider> boxes = Lists.newArrayList();

    public CombinedShape(BooleanOp operator, Collection<IShapeProvider> boxes) {
        this.operator = operator;
        this.boxes.addAll(boxes);
    }

    @Override
    public Optional<VoxelShape> getShape(BlockState state, Direction facing) {
        return this.boxes.stream().map(shape -> shape.getShape(state, facing)).reduce(Optional.empty(), (a, b) -> a.map(aa -> b.map(bb -> Shapes.m_83148_((VoxelShape)aa, (VoxelShape)bb, (BooleanOp)this.operator)).or(() -> a)).orElse((Optional)b)).map(VoxelShape::m_83296_);
    }

    @Override
    public IShapeProvider bake(Function<String, Property<?>> propertyLookup) {
        return new CombinedShape(this.operator, this.boxes.stream().map(s -> s.bake(propertyLookup)).collect(Collectors.toList()));
    }
}

